#ifndef _COMPLETELOOP_H__
#define _COMPLETELOOP_H__

#include <list>
#include <vector>
#include "sprig.h"
#include "Player.h"
#include "Level.h"
#include "gameloop.h"
#include "Libraries/PL_Loop.h"

using namespace PL;
using namespace std;

void showComplete(GameState* gs);

class CompleteState : public PL_State
{
	public:
	
	float startDelay;
	SDL_Surface* screen;
	
	const char* missionName;
	
	GameState* gameState;
	
	CompleteState()
		: PL_State()
		, startDelay(1.000)
		, screen(NULL)
		, missionName(NULL)
		, gameState(NULL)
	{
	    
    }
	
	virtual ~CompleteState()
	{}
	
};

class CompleteUpdate : public PL_Update
{
	public:
	
	CompleteUpdate()
		: PL_Update()
	{}
	
	virtual ~CompleteUpdate()
	{}
	
    virtual void update(PL_State* state);
};

class CompleteDraw : public PL_Draw
{
	public:
	
	CompleteDraw()
		: PL_Draw()
	{}
	
	virtual ~CompleteDraw()
	{}
	
    virtual void draw(PL_State* state);
	
};

class CompleteEvent : public PL_AnyEvent
{
	public:
	CompleteEvent()
		: PL_AnyEvent()
	{}
	
	virtual ~CompleteEvent()
	{}
	
    virtual bool handleEvent(PL_State* state, SDL_Event& event);
	
};











#endif


